//scilab 5.5.2 , OS: Ubuntu 14.04
//  Linear Convolution  in time and frequency domain

clc ;clear all;close ;

x=[1 2 3 4];//input ('enter the input sequence values x(n)= ');    // [1 2 3 4]
h=[1 -1 0 -1];//input('enter the impulse sequence values h(n) = ');..// [1 -1 0 -1]

L1 = length(x);
L2 = length(h);

//Method 1 Using Direct Convolution Sum Formula
for i = 1: L1 +L2 -1
 conv_sum = 0;
 for j = 1: i
 if ((( i - j +1) <= L2 ) &( j <= L1 ) )
 conv_sum = conv_sum + x ( j ) * h (i -j +1) ;
 end ;
y(i) = conv_sum ;
end ;
end ;

disp(y,' Convolution Sum using Direct Formula Method= ' )

 //Method 2 Using In built Function
f = convol(x,h)
disp(f, ' Convolution Sum Result using Inbuilt Function = ')

//Method 3 Using frequency Domain multiplication 
N = L1 +L2 -1;                                  //Linear convolution output length
x = [ x zeros(1 ,N - L1 ) ];
h = [ h zeros(1 ,N - L2 ) ];
f1 = fft(x)
f2 = fft(h)
f3 = f1.* f2 ;                                  // Multiplication in frequency domain
f4 = ifft(f3)
disp (f4 , 'Convolution Sum Result DFT and IDFT method = ')

//To plot input, impulse and output signals.
subplot (5,1,1) ;plot2d3(x);xtitle('Input signal x ','n','x[n]');
subplot(5,1,2) ;plot2d3(h);xtitle('Impulse signal h','n','h[n]');
subplot(5,1,3) ;plot2d3(y);xtitle('Liner Convolution using formula','n','y1[n]');
subplot(5,1,4) ;plot2d3(f);xtitle('Linear Convolution using Inbuilt function','n','y2[n]');
subplot(5,1,5) ;plot2d3(f);xtitle('Linear Convolution using DFT method','n','y3[n]');

// Expected result
//1.    1.    1.    0.  - 6.  - 3.  - 4.  

